IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD](
	[CD_EMP] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[CD_SIGLA] [int] NOT NULL,
	[VLR_PARAMETRO] [money] NOT NULL,
	[DS_ARV_PARAM] [varchar](250) NOT NULL,
	[FCURVA] [int] NOT NULL,
	[FCURVA_ULT_ATU] [datetime] NOT NULL,
	[DT_ULT_ALT] [datetime] NULL,
	[CD_ARV_PARAM] [int] NOT NULL,
	[CD_GRUPO_CURVA] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FILIAL] ASC,
	[CD_PROD] ASC,
	[CD_SIGLA] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_CD_SIGLA]  DEFAULT ((0)) FOR [CD_SIGLA]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_VLR_PARAMETRO]  DEFAULT ((0)) FOR [VLR_PARAMETRO]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_DS_ARV_PARAM]  DEFAULT ('') FOR [DS_ARV_PARAM]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_FCURVA]  DEFAULT ((0)) FOR [FCURVA]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_CD_ARV_PARAM]  DEFAULT ((0)) FOR [CD_ARV_PARAM]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_CD_GRUPO_CURVA]  DEFAULT ((0)) FOR [CD_GRUPO_CURVA]

ALTER TABLE [dbo].[EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD] ADD  CONSTRAINT [DF_EST_PARAM_COMPRAS_GRUPO_PRC_FILIAL_EST_PROD_DT_CAD]  DEFAULT (GETDATE()) FOR [DT_CAD]

END
